<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  
  define('INDEXU', 1);

  /*===================================================
    register_globals & magic_quotes_gpc = on
  ===================================================*/
  function safe_extract($var) {
    static $forbidden = array('_FILES', '_ENV', '_GET', '_POST', '_COOKIE', '_SERVER', '_SESSION', 'GLOBALS');
    while (list($k, $v) = @each($var)) {
      if (!in_array($k, $forbidden)) {
        $GLOBALS[$k] = $v;
      }
      else {
        exit;
      }
    }
  }
  function addslashes_deep($value) {
     $value = is_array($value) ? array_map('addslashes_deep', $value) : addslashes($value);
     return $value;
  }
  if (!get_magic_quotes_gpc()) {
    if (!empty($_GET)) {
      $_GET = addslashes_deep($_GET);
      safe_extract($_GET);
    }
    if (!empty($_POST)) {
      $_POST = addslashes_deep($_POST);
      safe_extract($_POST);
    }
    if (!empty($_COOKIE)) {
      $_COOKIE = addslashes_deep($_COOKIE);
      safe_extract($_COOKIE);
    }
  }
  elseif (!ini_get('register_globals')) {
    if (!empty($_GET)) safe_extract($_GET);
    if (!empty($_POST)) safe_extract($_POST);
    if (!empty($_COOKIE)) safe_extract($_COOKIE);
  }


  /*===================================================
    config
  ===================================================*/

  $dbServer               = "mysql";
  $dbHostname             = "localhost";
  $dbUsername             = "root";
  $dbPassword             = "";
  $dbName                 = "indexu";

  $site_url               = "http://indexu.null";
  $base_path              = "v:/home/null/indexu/";
  $theme_path             = $base_path . "themes/";
  $admin_template_path    = $base_path . "admin_tpl/";

  $site_name              = "Indexu NULL";

  $active_theme           = 'kosmos';

  $email_address          = "MyWebsite <me@mydomain.com>";

  $spam_proof             = 1;
  $enable_user_validation = 1;

  $allowed_file_extension = "gif,jpg,png,pdf,zip,doc";
  $google_key             = "";
  $whosonline             = "600";
  $reciprocal_check       = 0;
  $urlcheck_limit         = 1;      // days for re-check url
  $pagerank_cache         = 30;     // days for caching pagerank

  $max_image_width        = 1024;   // in pixel
  $max_image_height       = 756;    // in pixel
  $max_file_size          = 500;    // in KB

  $only_registered_can_add_link = 0;
  $only_registered_can_add_review = 0;
  $db_use_persistent      = 0;

  $paid_link_day_period   = "30,60,90,180";
  $paid_link_price_factor = "1,1.5,2,3";

  $enable_html_tag        = 1;
  $allowed_html_tag       = "<b>,<strong>,<i>,<em>,<u>,<pre>,<blockquote>,<ol>,<ul>,<li>";

  $enable_page_compression = 1;


  /*===================================================
    include
  ===================================================*/

  include $base_path . "lib/db.class.php";
  include $base_path . "lib/users.class.php";
  include $base_path . "lib/category.class.php";
  include $base_path . "lib/link.class.php";
  include $base_path . "lib/mailing_list.class.php";
  include $base_path . "lib/pagination.class.php";
  include $base_path . "lib/auth/auth.class.php";
  include $base_path . "lib/template.lib.php";
  include $base_path . "lib/form_validation.lib.php";
  include $base_path . "lib/mod-rewrite.lib.php";
  include $base_path . "lib/http.lib.php";
  include $base_path . "lib/filter.lib.php";
  include $base_path . "lib/payment.lib.php";
  include $base_path . "lib/misc.lib.php";
  include $base_path . "init.php";


  /*===================================================
    php configuration
  ===================================================*/

  ini_set("max_execution_time", "60");
  ini_set('session.use_trans_sid', false);
  ini_set('session.use_only_cookies', true);
  ini_set('url_rewriter.tags', '');

  $indexu_version = "5.3.0";

?>